#include "MenuState.h"
#include "StateManager.h"
#include "PlayState.h"
#include "Help.h"
#include "Option.h"

MenuState::MenuState()
{
	
}

MenuState::~MenuState()
{
	delete m_Arrow;
}

MenuState::MenuState(IDStateGame id)
{
	m_ID = id;
}

void MenuState::Init()
{
	m_ID = MENU;

	m_Arrow = new Arrow(6, 10, 6, 12, 2);
}

void MenuState::Update()
{
	//Selection
	m_Arrow->Update();

	if (GIsKeyPress(KEY_ENTER))
	{
		StateManager::getInstance()->removeStateGame();
		switch (m_Arrow->m_Position.y)
		{
			case 6:
			{
				StateManager::getInstance()->addStateGame(new PlayState(IDStateGame::PLAYGAME));
				break;
			}
			
			case 8:
			{
				  StateManager::getInstance()->addStateGame(new Option(IDStateGame::OPTION));
				  break;
			}
			case 10:
			{
				   StateManager::getInstance()->addStateGame(new Help(IDStateGame::HELP));
				   break;
			}
			case 12:
				exit(1);
				break;
		default:
			break;
		}
	}
}

void MenuState::Draw()
{
	m_Arrow->Draw();
	
	GPutStringToBuffer("Play Game", 15, 6);
	GPutStringToBuffer("Option", 15, 8);
	GPutStringToBuffer("Help", 15, 10);
	GPutStringToBuffer("Exit", 15, 12);

	GPutStringToBuffer("GAME XEP HINH", 12, 20);
	GPutStringToBuffer("Luu The Vinh - 13521043", 8, 25);
}